package com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;
import java.util.UUID;

/**
 * {@link InstitutionalPageRepository} repository.
 */
@Repository
public interface InstitutionalPageRepository extends
        JpaRepository<InstitutionalPageEntity, UUID>, JpaSpecificationExecutor<InstitutionalPageEntity> {

    Optional<InstitutionalPageEntity> findByOriginalInstitutionalPageId(UUID originalInstitutionalPageIds);

    List<InstitutionalPageEntity> findAllByParentInstitutionalPageIdInAndOriginalInstitutionalPageIdIsNull(
            List<UUID> parentInstitutionalPageIds
    );

    List<InstitutionalPageEntity> findAllByParentInstitutionalPageIdAndOriginalInstitutionalPageIdIsNull(
            UUID parentInstitutionalPageId
    );

    @Query(
            value = """
                    select ip.*
                    from institutional_page ip
                    where
                        (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))
                        and (:applyInstitutionalPageIdsFilter = false or coalesce(ip.original_institutional_page_id, ip.id) in (:institutionalPageIds))
                        and (:published is null or ip.published = :published)
                        and (:category is null or ip.category = :category)
                        and (:rootLevelOnly = false or ip.parent_institutional_page_id is null)
                        and (:originalVersionOnly = false or ip.original_institutional_page_id is null)
                        and (:latestVersionOnly = false or ip.updated_institutional_page_id is null)
                        and (:searchText is null or lower(ip.name) like lower(concat('%', cast(:searchText as varchar), '%')))
                    """,
            countQuery = """
                    select count(ip.id)
                    from institutional_page ip
                    where
                        (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))
                        and (:applyInstitutionalPageIdsFilter = false or coalesce(ip.original_institutional_page_id, ip.id) in (:institutionalPageIds))
                        and (:published is null or ip.published = :published)
                        and (:category is null or ip.category = :category)
                        and (:rootLevelOnly = false or ip.parent_institutional_page_id is null)
                        and (:originalVersionOnly = false or ip.original_institutional_page_id is null)
                        and (:latestVersionOnly = false or ip.updated_institutional_page_id is null)
                        and (:searchText is null or lower(ip.name) like lower(concat('%', cast(:searchText as varchar), '%')))
                    """,
            nativeQuery = true
    )
    Page<InstitutionalPageEntity> findAllFiltered(
            Pageable pageable,
            @Param("applyModerationStatusesFilter") boolean applyModerationStatusesFilter,
            @Param("moderationStatuses") List<String> moderationStatuses,
            @Param("applyInstitutionalPageIdsFilter") boolean applyInstitutionalPageIdsFilter,
            @Param("institutionalPageIds") List<UUID> institutionalPageIds,
            @Param("published") Boolean published,
            @Param("category") String category,
            @Param("rootLevelOnly") boolean rootLevelOnly,
            @Param("originalVersionOnly") boolean originalVersionOnly,
            @Param("latestVersionOnly") boolean latestVersionOnly,
            @Param("searchText") String searchText
    );

    @Query(
            value = """
                    SELECT ip.*
                    FROM institutional_page ip
                    LEFT JOIN institutional_page_member member
                        ON
                        (
                            member.member_id = :userId
                            AND (:wpLeaderOnly = false OR member.wp_lead = true)
                            AND
                            (
                                (
                                    member.wp_lead = false
                                    AND
                                    coalesce(ip.original_institutional_page_id, ip.id) = member.institutional_page_id
                                )
                                OR
                                (
                                    member.wp_lead = true
                                    AND
                                    coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id
                                )
                            )
                        )
                    WHERE
                        (:applyModerationStatusesFilter = false OR ip.moderation_status IN (:moderationStatuses))
                        AND (:applyInstitutionalPageIdsFilter = false OR coalesce(ip.original_institutional_page_id, ip.id) IN (:institutionalPageIds))
                        AND (:category IS NULL OR ip.category = :category)
                        AND (:rootLevelOnly = false OR ip.parent_institutional_page_id IS NULL)
                        AND (:searchText IS NULL OR lower(ip.name) LIKE lower(concat('%', cast(:searchText AS varchar), '%')))
                        AND
                        (
                            (
                                member.member_id IS NOT NULL
                                AND
                    	        (
                    	    	    ( :includePrivateAndMember = true AND ip.published = false )
                                    OR
                                    ( :includePublishedAndMember = true AND ip.published = true )
                                )
                                AND (:originalVersionOnly = false OR ip.original_institutional_page_id IS NULL)
                                AND (:latestVersionOnly = false OR ip.updated_institutional_page_id IS NULL)
                            )
                            OR
                            (
                                member.member_id IS NULL
                                AND :includePublishedAndNotMember = true
                                AND ip.published = true
                                AND ip.moderation_status = :approvedModerationStatusLabel
                            )
                        )
                    """,
            countQuery = """
                    SELECT COUNT(ip.id)
                    FROM institutional_page ip
                    LEFT JOIN institutional_page_member member
                        ON
                        (
                            member.member_id = :userId
                            AND (:wpLeaderOnly = false OR member.wp_lead = true)
                            AND
                            (
                                (
                                    member.wp_lead = false
                                    AND
                                    coalesce(ip.original_institutional_page_id, ip.id) = member.institutional_page_id
                                )
                                OR
                                (
                                    member.wp_lead = true
                                    AND
                                    coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id
                                )
                            )
                        )
                    WHERE
                        (:applyModerationStatusesFilter = false OR ip.moderation_status IN (:moderationStatuses))
                        AND (:applyInstitutionalPageIdsFilter = false OR coalesce(ip.original_institutional_page_id, ip.id) IN (:institutionalPageIds))
                        AND (:category IS NULL OR ip.category = :category)
                        AND (:rootLevelOnly = false OR ip.parent_institutional_page_id IS NULL)
                        AND (:searchText IS NULL OR lower(ip.name) LIKE lower(concat('%', cast(:searchText AS varchar), '%')))
                        AND
                        (
                            (
                                member.member_id IS NOT NULL
                                AND
                    	        (
                    	    	    ( :includePrivateAndMember = true AND ip.published = false )
                                    OR
                                    ( :includePublishedAndMember = true AND ip.published = true )
                                )
                                AND (:originalVersionOnly = false OR ip.original_institutional_page_id IS NULL)
                                AND (:latestVersionOnly = false OR ip.updated_institutional_page_id IS NULL)
                            )
                            OR
                            (
                                member.member_id IS NULL
                                AND :includePublishedAndNotMember = true
                                AND ip.published = true
                                AND ip.moderation_status = :approvedModerationStatusLabel
                            )
                        )
                    """,
            nativeQuery = true
    )
    Page<InstitutionalPageEntity> findAllForMemberFiltered(
            Pageable pageable,
            @Param("userId") UUID userId,
            @Param("wpLeaderOnly") boolean wpLeaderOnly,
            @Param("applyModerationStatusesFilter") boolean applyModerationStatusesFilter,
            @Param("moderationStatuses") List<String> moderationStatuses,
            @Param("applyInstitutionalPageIdsFilter") boolean applyInstitutionalPageIdsFilter,
            @Param("institutionalPageIds") List<UUID> institutionalPageIds,
            @Param("includePrivateAndMember") boolean includePrivateAndMember,
            @Param("includePublishedAndMember") boolean includePublishedAndMember,
            @Param("includePublishedAndNotMember") boolean includePublishedAndNotMember,
            @Param("category") String category,
            @Param("rootLevelOnly") boolean rootLevelOnly,
            @Param("originalVersionOnly") boolean originalVersionOnly,
            @Param("latestVersionOnly") boolean latestVersionOnly,
            @Param("searchText") String searchText,
            @Param("approvedModerationStatusLabel") String approvedModerationStatusLabel
    );

    @Query(
            value = """
                    select ip.*
                    from institutional_page ip
                    join institutional_page_member member
                        on
                        (
                            member.member_id = :userId
                            and member.institutional_page_id = :rootInstitutionalPageId
                            and member.wp_lead = true
                            and coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id
                        )
                    where
                        (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))
                        and (:originalVersionOnly = false or ip.original_institutional_page_id is null)
                    """,
            countQuery = """
                    select count(ip.id)
                    from institutional_page ip
                    join institutional_page_member member
                        on
                        (
                            member.member_id = :userId
                            and member.institutional_page_id = :rootInstitutionalPageId
                            and member.wp_lead = true
                            and coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = member.institutional_page_id
                        )
                    where
                        (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))
                        and (:originalVersionOnly = false or ip.original_institutional_page_id is null)
                    """,
            nativeQuery = true
    )
    Page<InstitutionalPageEntity> findHierarchyForMemberFiltered(
            Pageable pageable,
            @Param("userId") UUID userId,
            @Param("rootInstitutionalPageId") UUID rootInstitutionalPageId,
            @Param("applyModerationStatusesFilter") boolean applyModerationStatusesFilter,
            @Param("moderationStatuses") List<String> moderationStatuses,
            @Param("originalVersionOnly") boolean originalVersionOnly
    );

    @Query(
            value = """
                    select ip.*
                    from institutional_page ip
                    where
                        coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = :rootInstitutionalPageId
                        and (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))
                        and (:originalVersionOnly = false or ip.original_institutional_page_id is null)
                    """,
            countQuery = """
                    select count(ip.id)
                    from institutional_page ip
                    where
                        coalesce(ip.ancestor_institutional_page_ids[1], ip.original_institutional_page_id, ip.id) = :rootInstitutionalPageId
                        and (:applyModerationStatusesFilter = false or ip.moderation_status in (:moderationStatuses))
                        and (:originalVersionOnly = false or ip.original_institutional_page_id is null)
                    """,
            nativeQuery = true
    )
    Page<InstitutionalPageEntity> findHierarchyFiltered(
            Pageable pageable,
            @Param("rootInstitutionalPageId") UUID rootInstitutionalPageId,
            @Param("applyModerationStatusesFilter") boolean applyModerationStatusesFilter,
            @Param("moderationStatuses") List<String> moderationStatuses,
            @Param("originalVersionOnly") boolean originalVersionOnly
    );

}
