/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.repository;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.MembershipModel;
import java.util.List;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MemberRepository
extends JpaRepository<MemberEntity, UUID> {
    public boolean existsByMemberIdAndInstitutionalPageIdAndWpLead(UUID var1, UUID var2, boolean var3);

    public List<MemberEntity> findAllByInstitutionalPageIdInAndWpLead(List<UUID> var1, boolean var2);

    public List<MemberEntity> findAllByInstitutionalPageIdAndMemberIdInAndWpLead(UUID var1, List<UUID> var2, boolean var3);

    @Modifying
    @Query(value="delete from institutional_page_member member\nusing institutional_page ip\nwhere\n    member.institutional_page_id = ip.id\n    and ip.ancestor_institutional_page_ids[1] = :rootInstitutionalPageId\n    and member.wp_lead = false\n    and member.member_id in (:userIds)\n", nativeQuery=true)
    public void deleteRegularMembersFromDescendants(@Param(value="rootInstitutionalPageId") UUID var1, @Param(value="userIds") List<UUID> var2);

    @Query(value="select distinct member.member_id, member.wp_lead\nfrom institutional_page_member member\njoin institutional_page ip on ip.id = member.institutional_page_id\nwhere coalesce(ip.ancestor_institutional_page_ids[1], ip.id) = :rootInstitutionalPageId\norder by member.wp_lead desc, member.member_id\n", countQuery="select count(distinct member.member_id, member.wp_lead)\nfrom institutional_page_member member\njoin institutional_page ip on ip.id = member.institutional_page_id\nwhere coalesce(ip.ancestor_institutional_page_ids[1], ip.id) = :rootInstitutionalPageId\norder by member.wp_lead desc, member.member_id\n", nativeQuery=true)
    public Page<MembershipModel> findDistinctMemberIdsOrderedByWpLead(Pageable var1, @Param(value="rootInstitutionalPageId") UUID var2);

    @Query(value="select member.*\nfrom institutional_page_member member\njoin institutional_page ip on ip.id = member.institutional_page_id\nwhere\n    coalesce(ip.ancestor_institutional_page_ids[1], ip.id) = :rootInstitutionalPageId\n    and member.member_id in (:memberIds)\n", nativeQuery=true)
    public List<MemberEntity> findAllMembersByRootIdAndMemberIds(@Param(value="rootInstitutionalPageId") UUID var1, @Param(value="memberIds") List<UUID> var2);
}

