package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

/**
 * Output Dto of a paragraph related to the institutional page.
 */
@Schema(name = "OutputParagraphDto", description = "Output DTO of a paragraph related to the institutional page")
@Data
@Builder
@AllArgsConstructor
public class OutputParagraphDto {

    @Schema(description = "The ID of the paragraph", example = "44444444-aaaa-1111-0000-000000000000")
    private UUID id;

    @Schema(description = "The title of the paragraph", example = "Outcomes")
    private String title;

    @Schema(description = "The content of the paragraph", example = "A shared library of reusable software components")
    private String content;

    @Schema(description = "The image url of the paragraph", example = "https://picsum.photos/200")
    private String imageUrl;

    @Schema(description = "The resource url of the paragraph", example = "https://www.example.com/")
    private String resourceUrl;

    @Schema(description = "list of labels related to the paragraph", example = "[\"god\",\"marriage\"]")
    private List<String> labels;

}
