package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;

import java.util.UUID;

public class NotInstitutionalPageWPLeaderException extends WP2ResourceNotFoundException {

    public static final String EXCEPTION_MESSAGE =
            "User with id '%s' is not WP Leader of any institutionalPage having id '%s'";

    public NotInstitutionalPageWPLeaderException(
            UUID userId,
            UUID institutionalPageId
    ) {
        super(EXCEPTION_MESSAGE.formatted(userId, institutionalPageId));
    }

}
