/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.ModerationApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPModerationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchModerationInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputModerationDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ModerationController
implements ModerationApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModerationController.class);
    private final InstitutionalPageService institutionalPageService;

    public Page<OutputInstitutionalPageDto> findAllModerationInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/moderation");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.findAllModerationInstitutionalPages(userId, associationsToLoad, (Pageable)pageable);
    }

    public Page<OutputInstitutionalPageDto> searchModerationInstitutionalPages(InputSearchModerationInstitutionalPageDto inputSearchModerationInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/moderation/search, inputSearchModerationInstitutionalPageDto: {}", (Object)inputSearchModerationInstitutionalPageDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort.Direction)direction, (String[])new String[]{sort});
        return this.institutionalPageService.searchModerationInstitutionalPages(userId, associationsToLoad, (Pageable)pageable, inputSearchModerationInstitutionalPageDto);
    }

    public OutputInstitutionalPageDto findModerationInstitutionalPageById(UUID institutionalPageId) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/moderation/{}", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.findModerationInstitutionalPageById(userId, institutionalPageId);
    }

    public OutputModerationDto acceptOrRejectPendingInstitutionalPage(UUID institutionalPageId, InputPatchIPModerationRequestDto inputPatchIPModerationRequestDto) {
        log.debug("PATCH /api/v1/dm/institutional-page/institutional-pages/moderation/{}, inputPatchIPModerationRequestDto: {}", (Object)institutionalPageId, (Object)inputPatchIPModerationRequestDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.institutionalPageService.acceptOrRejectPendingInstitutionalPage(userId, institutionalPageId, inputPatchIPModerationRequestDto);
    }

    @Generated
    public ModerationController(InstitutionalPageService institutionalPageService) {
        this.institutionalPageService = institutionalPageService;
    }
}

