package com.finconsgroup.itserr.marketplace.label.dm.controller;

import com.finconsgroup.itserr.marketplace.label.dm.api.LabelApi;
import com.finconsgroup.itserr.marketplace.label.dm.dto.InputCreateLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.OutputLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.service.LabelService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * Spring Boot REST Controller implementation for the {@link LabelApi} endpoints.
 */
@RestController
@RequiredArgsConstructor
@Slf4j
public class LabelController implements LabelApi {

    private final LabelService labelService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        // trim strings before triggering validation, but do not convert to null
        // as otherwise it throws - MissingServletRequestParameterException
        binder.registerCustomEditor(String.class, new StringTrimmerEditor(false));
    }

    @NonNull
    @Override
    public OutputLabelDto create(InputCreateLabelDto dto) {
        return labelService.create(dto);
    }

    @NonNull
    @Override
    public OutputLabelDto get(UUID labelId) {
        return labelService.findById(labelId);
    }

    @Override
    public void delete(UUID labelId) {
        labelService.deleteById(labelId);
    }

    @NonNull
    @Override
    public Page<OutputLabelDto> findByContextAndName(String context, String name, int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        Pageable pageable = PageRequest.of(pageNumber, pageSize, direction, sort);
        return labelService.findByContextAndName(context, name, pageable);
    }
}
