package com.finconsgroup.itserr.marketplace.label.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;

/**
 * Label response dto.
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class OutputLabelDto {

    @Schema(
        description = "Label id",
        example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private String id;

    @Schema(
        description = "Label name",
        example = "english")
    private String name;

    @Schema(
        description = "Label context",
        example = "languages")
    private String context;

    @Schema(
        description = "Created At",
        example = "2025-05-26T14:19:46.606883Z")
    private Instant creationTimestamp;
}
