package com.finconsgroup.itserr.marketplace.label.dm.mapper;

import com.finconsgroup.itserr.marketplace.label.dm.dto.InputCreateLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.OutputLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.entity.LabelEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.springframework.lang.NonNull;

/**
 * Mapper for all dto/entity conversions related to {@link com.finconsgroup.itserr.marketplace.label.dm.entity.LabelEntity}
 */
@Mapper(config = MapperConfiguration.class)
public interface LabelMapper {

    /**
     * Maps a {@link InputCreateLabelDto} to a {@link LabelEntity}
     *
     * @param dto the source dto
     * @return the mapped entity
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTimestamp", ignore = true)
    LabelEntity createDtoToEntity(@NonNull InputCreateLabelDto dto);

    /**
     * Maps a {@link LabelEntity} to an {@link OutputLabelDto}
     *
     * @param entity the source entity
     * @return the mapped dto
     */
    OutputLabelDto toOutputDto(@NonNull LabelEntity entity);
}
