/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.label.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2DuplicateResourceException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.label.dm.config.LabelProperties;
import com.finconsgroup.itserr.marketplace.label.dm.dto.InputCreateLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.dto.OutputLabelDto;
import com.finconsgroup.itserr.marketplace.label.dm.entity.LabelEntity;
import com.finconsgroup.itserr.marketplace.label.dm.mapper.LabelMapper;
import com.finconsgroup.itserr.marketplace.label.dm.repository.LabelRepository;
import com.finconsgroup.itserr.marketplace.label.dm.service.LabelService;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultLabelService
implements LabelService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultLabelService.class);
    private static final String FORMAT_BUSINESS_KEY = "{name: %s, context: %s}";
    private final LabelProperties labelProperties;
    private final LabelRepository labelRepository;
    private final LabelMapper labelMapper;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputLabelDto create(@NonNull InputCreateLabelDto dto) {
        if (this.labelRepository.countByNameIgnoreCaseAndContextIgnoreCase(dto.getName(), dto.getContext()) > 0) {
            throw new WP2DuplicateResourceException(FORMAT_BUSINESS_KEY.formatted(dto.getName(), dto.getContext()));
        }
        LabelEntity labelEntity = this.labelMapper.createDtoToEntity(dto);
        LabelEntity savedLabelEntity = (LabelEntity)this.labelRepository.save((Object)labelEntity);
        return this.labelMapper.toOutputDto(savedLabelEntity);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputLabelDto findById(@NonNull UUID labelId) {
        OutputLabelDto outputLabelDto = this.labelRepository.findById((Object)labelId).map(arg_0 -> ((LabelMapper)this.labelMapper).toOutputDto(arg_0)).orElseThrow(() -> new WP2ResourceNotFoundException(labelId));
        return outputLabelDto;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteById(@NonNull UUID labelId) {
        if (!this.labelProperties.allowDelete()) {
            throw new WP2BusinessException("Delete not allowed");
        }
        if (!this.labelRepository.existsById((Object)labelId)) {
            throw new WP2ResourceNotFoundException(labelId);
        }
        this.labelRepository.deleteById((Object)labelId);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputLabelDto> findByContextAndName(@NonNull String context, String name, @NonNull Pageable pageable) {
        Page labelsResult = StringUtils.isNotBlank((CharSequence)name) ? this.labelRepository.findByContextIgnoreCaseAndNameStartsWithIgnoreCase(context, name, pageable) : this.labelRepository.findByContextIgnoreCase(context, pageable);
        return labelsResult.map(arg_0 -> ((LabelMapper)this.labelMapper).toOutputDto(arg_0));
    }

    @Generated
    public DefaultLabelService(LabelProperties labelProperties, LabelRepository labelRepository, LabelMapper labelMapper) {
        this.labelProperties = labelProperties;
        this.labelRepository = labelRepository;
        this.labelMapper = labelMapper;
    }
}

