package com.finconsgroup.itserr.marketplace.metadata.bs.service;

import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.exception.WP2ServiceUnavailableException;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * Metadata related service.
 */
public interface MetadataService {

    /**
     * Creates a new metadata.
     * @param request Creation request. Cannot be null.
     * @return Created metadata. Never null.
     * @throws com.finconsgroup.itserr.marketplace.metadata.bs.exception.MetadataExistsException when a metadata with the same name already exists.
     * @throws WP2ServiceUnavailableException when downstream service is not available.
     */
    @NonNull
    OutputMetadataDto create(@NonNull InputCreateMetadataDto request);

    /**
     * Deletes a metadata by id.
     * @param id Metadata id.
     * @return Deleted metadata. Never null.
     * @throws com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException Metadata was not found.
     */
    @NonNull
    OutputMetadataDto deleteById(@NonNull UUID id);

}
