/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.api;

import com.finconsgroup.itserr.marketplace.metadata.bs.dto.InputCreateMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Metadata", description="Operations related to metadata")
@SecurityRequirement(name="BearerAuth")
public interface MetadataApi {
    @Operation(summary="Creates a new metadata", description="Creates a new metadata.", responses={@ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="409", description="Another metadata exists with the same name", content={@Content}), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content})})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PostMapping(path={"/metadata"}, consumes={"application/json"}, produces={"application/json"})
    public OutputMetadataDto create(@Valid @RequestBody InputCreateMetadataDto var1);

    @Operation(summary="Deletes a metadata by id", responses={@ApiResponse(responseCode="200", description="Deleted"), @ApiResponse(responseCode="404", description="Metadata was not found", content={@Content}), @ApiResponse(responseCode="503", description="Service unavailable", content={@Content})})
    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping(value={"/metadata/{metadataId}"}, produces={"application/json"})
    public OutputMetadataDto deleteById(@PathVariable(value="metadataId") UUID var1);
}

