/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.bs.api.DiagnosticsApi;
import com.finconsgroup.itserr.marketplace.metadata.bs.config.MetadataBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.enums.EventType;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class DiagnosticsController
implements DiagnosticsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DiagnosticsController.class);
    private final ResourceProducer resourceProducer;
    private final MetadataBsConfigurationProperties metadataBsConfigurationProperties;
    static Map<String, OutputMetadataDto> stringOutputMetadataDtoHashMap = new HashMap();
    @Value(value="${log.log4j2-rolling-file-name}")
    private String log4j2RollingFileName;

    public ResponseEntity<Resource> downloadLogs() {
        log.debug("call to DiagnosticsController - downloadLogs");
        Path filePath = Paths.get(this.getLogFilePathFromLog4j2(), new String[0]);
        log.debug("Trying to retrieve log file from: {}", (Object)filePath);
        File logFile = filePath.toFile();
        if (!logFile.exists() || !logFile.isFile()) {
            throw new WP2ResourceNotFoundException("Log file not found: %s".formatted(logFile.getAbsolutePath()));
        }
        FileSystemResource resource = new FileSystemResource(logFile);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{DiagnosticsController.getContentDispositionHeaderValue((String)logFile.getName())})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)resource);
    }

    public String getLogFilePathFromLog4j2() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        RollingFileAppender appender = (RollingFileAppender)context.getConfiguration().getAppender(this.log4j2RollingFileName);
        return appender.getFileName();
    }

    private static String getContentDispositionHeaderValue(String fileName) {
        return "attachment; filename=\"%s\"".formatted(fileName);
    }

    public ResponseEntity<String> publishMessage(EventType eventType, String name) {
        OutputMetadataDto outputMetadataDto;
        if (!this.metadataBsConfigurationProperties.getDiagnostics().isPublishMessageEnabled()) {
            log.warn("Attempt to access disabled diagnostics endpoint");
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)"This endpoint is disabled in the current environment");
        }
        log.debug("call to DiagnosticsController - publishMessage, name: %s".formatted(name));
        EventType eventType2 = eventType;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"CREATED", "DELETED"}, (EventType)eventType2, n)) {
            case 0: {
                outputMetadataDto = OutputMetadataDto.builder().id(UUID.randomUUID()).name(name).description("the CREATED description").build();
                log.info("sending created message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.put(outputMetadataDto.getName(), outputMetadataDto);
                this.resourceProducer.publishCreatedResource(outputMetadataDto);
                break;
            }
            case 1: {
                outputMetadataDto = (OutputMetadataDto)stringOutputMetadataDtoHashMap.get(name);
                if (outputMetadataDto == null) {
                    return ResponseEntity.badRequest().body((Object)"no test item created for name: %s".formatted(name));
                }
                log.info("sending deleted message, outputMetadataDto: %s".formatted(outputMetadataDto));
                stringOutputMetadataDtoHashMap.remove(outputMetadataDto.getName());
                this.resourceProducer.publishDeletedResource(outputMetadataDto.getId());
                break;
            }
            default: {
                return ResponseEntity.badRequest().body((Object)"Event type must be one of: CREATED, UPDATED, DELETED");
            }
        }
        return ResponseEntity.ok((Object)"message sent correctly, outputMetadataDto: %s".formatted(outputMetadataDto));
    }

    @Generated
    public DiagnosticsController(ResourceProducer resourceProducer, MetadataBsConfigurationProperties metadataBsConfigurationProperties) {
        this.resourceProducer = resourceProducer;
        this.metadataBsConfigurationProperties = metadataBsConfigurationProperties;
    }
}

