package com.finconsgroup.itserr.marketplace.metadata.bs.service.impl;

import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataFieldExtDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataPreviewDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataFieldExtDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataPreviewDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.service.UserProfileDetailProvider;
import lombok.RequiredArgsConstructor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;

@Component
@RequiredArgsConstructor
public class UserProfileHelper {

    private final UserProfileDetailProvider userProfileDetailProvider;

    public Map<UUID, OutputUserProfileDto> fetchUserDetailsFromPreviews(List<OutputMetadataPreviewDmDto> outputMetadataPreviewDmDtoList) {
        List<UUID> userIds = outputMetadataPreviewDmDtoList.stream()
                .flatMap(dm -> Stream.of(dm.getCreatorId()))
                .filter(Objects::nonNull)
                .distinct().toList();

        return userIds.isEmpty() ? Map.of() : userProfileDetailProvider.getUserDetailById(userIds);
    }

    public Map<UUID, OutputUserProfileDto> fetchUserDetailsFromMetadataFieldExt(List<OutputMetadataFieldExtDmDto> outputMetadataFieldExtDmDtoList) {
        List<UUID> userIds = outputMetadataFieldExtDmDtoList.stream()
                .flatMap(dm -> Stream.of(dm.getMetadata().getCreatorId()))
                .filter(Objects::nonNull)
                .distinct().toList();

        return userIds.isEmpty() ? Map.of() : userProfileDetailProvider.getUserDetailById(userIds);
    }

    public Map<UUID, OutputUserProfileDto> fetchUserDetails(List<OutputMetadataDmDto> outputMetadataDmDtoList) {
        List<UUID> userIds = outputMetadataDmDtoList.stream()
                .flatMap(dm -> Stream.of(dm.getCreatorId(), dm.getUpdatedBy()))
                .filter(Objects::nonNull)
                .distinct().toList();

        return userIds.isEmpty() ? Map.of() : userProfileDetailProvider.getUserDetailById(userIds);
    }

    public void enrichMetadataDto(@NonNull OutputMetadataDmDto dmDto,
                                  @NonNull OutputMetadataDto outputMetadataDto,
                                  Map<UUID, OutputUserProfileDto> userDetails) {
        outputMetadataDto.setCreator(getUserProfile(dmDto.getCreatorId(), userDetails));
        outputMetadataDto.setUpdatedBy(getUserProfile(dmDto.getUpdatedBy(), userDetails));
    }

    public void enrichMetadataPreviewDto(@NonNull OutputMetadataPreviewDmDto dmDto,
                                         @NonNull OutputMetadataPreviewDto outputMetadataPreviewDto,
                                         Map<UUID, OutputUserProfileDto> userDetails) {
        outputMetadataPreviewDto.setCreator(getUserProfile(dmDto.getCreatorId(), userDetails));
    }

    public void enrichMetadataFieldExtDto(@NonNull OutputMetadataFieldExtDmDto dmDto,
                                          @NonNull OutputMetadataFieldExtDto outputMetadataFieldExtDto,
                                          Map<UUID, OutputUserProfileDto> userDetails) {
        outputMetadataFieldExtDto.getMetadata().setCreator(getUserProfile(dmDto.getMetadata().getCreatorId(), userDetails));
    }

    private OutputUserProfileDto getUserProfile(UUID userId, Map<UUID, OutputUserProfileDto> userDetails) {
        return userDetails.getOrDefault(userId, OutputUserProfileDto.builder().id(userId).build());
    }
}
