/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto;

import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.MetadataCategoryDmEnum;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.MetadataDmStatus;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataDmDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.client.metadatadm.dto.OutputMetadataFieldDmDto;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Schema(name="Metadata", description="Represents a metadata")
public class OutputMetadataDmDto {
    public static final int NAME_LENGTH = 50;
    public static final int DESCRIPTION_LENGTH = 2000;
    @Schema(description="Metadata id", example="f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    @NotBlank
    private UUID id;
    @Schema(description="Metadata name", example="Dublin Core (DC)")
    @NotBlank
    @Size(max=50)
    private @NotBlank @Size(max=50) String name;
    @Schema(description="Metadata description", example="Standard metadata for digital resources.")
    @Size(max=2000)
    private @Size(max=2000) String description;
    @Schema(description="Metadata category")
    private MetadataCategoryDmEnum category;
    @Schema(description="The ID of the creator", example="f81d4fae-7dec-11d0-a765-00a0c91e6bf6")
    private UUID creatorId;
    @Schema(description="Metadata fields")
    @NotEmpty
    private List<OutputMetadataFieldDmDto> fields;
    @Schema(description="Current status of the metadata", example="DRAFT")
    private MetadataDmStatus status;
    @Schema(description="Moderation message", example="Metadata approved after review")
    private String moderationMessage;
    @Schema(description="Creation timestamp", example="2025-11-14T10:00:00Z")
    private Instant createdAt;
    @Schema(description="Last update timestamp", example="2025-11-14T10:00:00Z")
    private Instant updatedAt;
    @Schema(description="User who last updated the metadata", example="3fa85f64-5717-4562-b3fc-2c963f66afa6")
    private UUID updatedBy;

    @Generated
    public static OutputMetadataDmDtoBuilder builder() {
        return new OutputMetadataDmDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MetadataCategoryDmEnum getCategory() {
        return this.category;
    }

    @Generated
    public UUID getCreatorId() {
        return this.creatorId;
    }

    @Generated
    public List<OutputMetadataFieldDmDto> getFields() {
        return this.fields;
    }

    @Generated
    public MetadataDmStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getModerationMessage() {
        return this.moderationMessage;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public UUID getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCategory(MetadataCategoryDmEnum category) {
        this.category = category;
    }

    @Generated
    public void setCreatorId(UUID creatorId) {
        this.creatorId = creatorId;
    }

    @Generated
    public void setFields(List<OutputMetadataFieldDmDto> fields) {
        this.fields = fields;
    }

    @Generated
    public void setStatus(MetadataDmStatus status) {
        this.status = status;
    }

    @Generated
    public void setModerationMessage(String moderationMessage) {
        this.moderationMessage = moderationMessage;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setUpdatedBy(UUID updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutputMetadataDmDto)) {
            return false;
        }
        OutputMetadataDmDto other = (OutputMetadataDmDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MetadataCategoryDmEnum this$category = this.getCategory();
        MetadataCategoryDmEnum other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        UUID this$creatorId = this.getCreatorId();
        UUID other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        MetadataDmStatus this$status = this.getStatus();
        MetadataDmStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$moderationMessage = this.getModerationMessage();
        String other$moderationMessage = other.getModerationMessage();
        if (this$moderationMessage == null ? other$moderationMessage != null : !this$moderationMessage.equals(other$moderationMessage)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        UUID this$updatedBy = this.getUpdatedBy();
        UUID other$updatedBy = other.getUpdatedBy();
        return !(this$updatedBy == null ? other$updatedBy != null : !((Object)this$updatedBy).equals(other$updatedBy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutputMetadataDmDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MetadataCategoryDmEnum $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        UUID $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        MetadataDmStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $moderationMessage = this.getModerationMessage();
        result = result * 59 + ($moderationMessage == null ? 43 : $moderationMessage.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        UUID $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : ((Object)$updatedBy).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OutputMetadataDmDto(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", category=" + String.valueOf(this.getCategory()) + ", creatorId=" + String.valueOf(this.getCreatorId()) + ", fields=" + String.valueOf(this.getFields()) + ", status=" + String.valueOf(this.getStatus()) + ", moderationMessage=" + this.getModerationMessage() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", updatedBy=" + String.valueOf(this.getUpdatedBy()) + ")";
    }

    @Generated
    public OutputMetadataDmDto() {
    }

    @Generated
    public OutputMetadataDmDto(UUID id, String name, String description, MetadataCategoryDmEnum category, UUID creatorId, List<OutputMetadataFieldDmDto> fields, MetadataDmStatus status, String moderationMessage, Instant createdAt, Instant updatedAt, UUID updatedBy) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.category = category;
        this.creatorId = creatorId;
        this.fields = fields;
        this.status = status;
        this.moderationMessage = moderationMessage;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
    }
}

