package com.finconsgroup.itserr.marketplace.metadata.bs.dto;


import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.Singular;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.metadata.bs.constants.Constants.METADATA_DESCRIPTION_LENGTH;
import static com.finconsgroup.itserr.marketplace.metadata.bs.constants.Constants.METADATA_NAME_LENGTH;

/**
 * Metadata create request DTO.
 */
@Schema(
        name = "MetadataCreateRequest",
        description = "Metadata creation request"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InputUpdateMetadataDto {

    @Schema(
            description = "Metadata name",
            example = "Dublin Core (DC)")
    @NotBlank
    @Size(max = METADATA_NAME_LENGTH)
    private String name;

    @Schema(
            description = "Metadata description",
            example = "Standard metadata for digital resources.")
    @Size(max = METADATA_DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Metadata category")
    private MetadataCategoryEnum category;

    @Schema(description = "Metadata fields")
    @NotEmpty
    @Valid
    @Singular
    private List<InputUpdateMetadataFieldDto> fields;

}
