create schema if not exists "wp2_metadata";

set schema 'wp2_metadata';

create table if not exists "metadata" (
  id uuid primary key,
  name varchar(50) not null unique,
  description varchar(255),
  standard boolean not null,
  version bigint
);

create table if not exists "metadata_field" (
  id uuid primary key,
  metadata_id uuid not null,
  name varchar(50) not null,
  description varchar(255),
  type varchar(20) not null,
  vocabulary text,
  validation varchar(255),
  mandatory boolean,
  foreign key (metadata_id) references "metadata"(id)
);

create table if not exists "archived_metadata" (
  id uuid primary key,
  name varchar(50) not null,
  description varchar(255),
  standard boolean not null
);

create table if not exists "archived_metadata_field" (
  id uuid primary key,
  metadata_id uuid,
  name varchar(50) not null,
  description varchar(255),
  type varchar(20) not null,
  vocabulary text,
  validation varchar(255),
  mandatory boolean,
  foreign key (metadata_id) references "archived_metadata"(id)
);

--comment: SCRUM-3068 add category column to metadata table
alter table "metadata" add column "category" varchar(50);

--comment: SCRUM-3068 add category creator_id to metadata table
alter table "metadata" add column "creator_id" UUID;

--comment: SCRUM-3068 drop column standard from metadata table
alter table "metadata" drop column "standard";

--comment: SCRUM-3068 add category column to archived_metadata table
alter table "archived_metadata" add column "category" varchar(50);

--comment: SCRUM-3068 add category creator_id to archived_metadata table
alter table "archived_metadata" add column "creator_id" UUID;

--comment: SCRUM-3068 drop column standard from archived_metadata table
alter table "archived_metadata" drop column "standard";