package com.finconsgroup.itserr.marketplace.metadata.dm.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Version;
import jakarta.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;
import java.util.UUID;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;

/**
 * This entity represents a metadata.
 */
@Entity
@Table(name = "metadata")
@SuperBuilder
@Data
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class MetadataEntity extends AbstractUUIDEntity {

    /**
     * Name field length.
     */
    public static final int NAME_LENGTH = 50;

    /**
     * Description field length.
     */
    public static final int DESCRIPTION_LENGTH = 2000;

    @Version
    private Long version;

    /**
     * Metadata name.
     */
    @Column(name = "name", nullable = false, length = NAME_LENGTH, unique = true)
    private String name;

    /**
     * Metadata description.
     */
    @Column(name = "description", length = DESCRIPTION_LENGTH)
    private String description;

    /**
     * Metadata category.
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "category", nullable = false)
    private MetadataCategoryEnum category;

    /**
     * The ID of the user who created the Metadata.
     */
    @Column(name = "creator_id")
    private UUID creatorId;

    /**
     * Metadata fields.
     */
    //TODO: may we use JPA Metamodel constants?
    @OneToMany(mappedBy = "metadata", cascade = CascadeType.ALL, orphanRemoval = true)
    private List<MetadataFieldEntity> fields;

}
