package com.finconsgroup.itserr.marketplace.metadata.dm.dto.bind;

import java.beans.PropertyEditorSupport;
import java.util.UUID;

/**
 * <p>Sets a {@link UUID} from a {@link String}.</p>
 * <p>
 * <span>This class implements the following behavior:</span>
 * <ul>
 *     <li>if the string is null, sets null;</li>
 *     <li>if the string represents a valid UUID, sets the corresponding {@link UUID} instance;</li>
 *     <li>If the string is invalid, sets the {@link #DEFAULT_UUID} default value. </li>
 * </ul>
 * </p>
 */
public class UUIDOrDefaultPropertyEditor extends PropertyEditorSupport {

    /**
     * Default UUID to be returned when the string is invalid.
     */
    public static final UUID DEFAULT_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");

    @Override
    public void setAsText(final String text) throws IllegalArgumentException {

        try {

            // If null, return null
            if (text == null) {

                setValue(null);

            } else {

                // Set UUID
                setValue(UUID.fromString(text.trim()));

            }

        } catch (final Exception e) {

            // Value was invalid, set the default UUID
            setValue(DEFAULT_UUID);

        }

    }

}
