package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.utils.AOPUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.UUID;

@Aspect
@Component
@Order(1)
@Slf4j
@RequiredArgsConstructor
public class StatusAspect {
    private final MetadataRepository metadataRepository;

    @Around("@annotation(requireMetadataStatus)")
    public Object requireMetadataStatus(ProceedingJoinPoint pjp, RequireMetadataStatus requireMetadataStatus) throws Throwable {
        UUID metadataId = AOPUtils.extractActualParam(pjp, requireMetadataStatus.metadataIdParam(), UUID.class);
        MetadataEntity metadataEntity = metadataRepository.findById(metadataId).orElseThrow(() ->
                new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId))
        );

        List<MetadataStatus> allowedStatuses = List.of(requireMetadataStatus.allowed());

        boolean isInAllowedStatus =
                allowedStatuses.stream().anyMatch(allowedStatus -> allowedStatus.equals(metadataEntity.getStatus()));

        if (!isInAllowedStatus) {
            throw new WP2AuthorizationException(String.format("Metadata %s is not in allowed status: %s", metadataId, allowedStatuses));
        }

        return pjp.proceed();
    }
}
