package com.finconsgroup.itserr.marketplace.metadata.dm.controller;

import com.finconsgroup.itserr.marketplace.metadata.dm.api.MetadataInternalApi;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.InputInternalFindMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.bind.UUIDOrDefaultPropertyEditor;
import com.finconsgroup.itserr.marketplace.metadata.dm.service.MetadataService;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.UUID;

/**
 * Metadata internal controller.
 */
@RestController
@RequiredArgsConstructor
public class MetadataInternalController implements MetadataInternalApi {

    public static final String FIND_REQUEST_BINDER = "findRequest";

    private final MetadataService metadataService;

    @Override
    public List<OutputMetadataDto> find(
            @ModelAttribute(FIND_REQUEST_BINDER) final InputInternalFindMetadataDto request) {
        return metadataService.find(request);
    }

    /**
     * <p>Specializes {@link WebDataBinder} for the {@link InputInternalFindMetadataDto}.</p>
     * <p>
     * <span>The following behaviors are implemented:</span>
     *     <ul>
     *         <li>all invalid (non UUID) values in {@link InputInternalFindMetadataDto#getId()} are converted into a default UUID instead of crashing the request.</li>
     *     </ul>
     * </p>
     * @param binder Binder.
     */
    @InitBinder(FIND_REQUEST_BINDER)
    private void initBinder(final WebDataBinder binder) {
        binder.registerCustomEditor(UUID.class, new UUIDOrDefaultPropertyEditor());
    }

}
