package com.finconsgroup.itserr.marketplace.metadata.dm.repository;

import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import org.jetbrains.annotations.NotNull;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

import java.util.Optional;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.metadata.dm.constants.Caches.METADATA_CACHE;

/**
 * {@link MetadataEntity} repository.
 */
@Repository
public interface MetadataRepository extends JpaRepository<MetadataEntity, UUID>, JpaSpecificationExecutor<MetadataEntity> {

    /**
     * Counts metadata having the given name.
     *
     * @param name Name.
     * @return Number of metadata matching the name.
     */
    int countByNameIgnoreCase(@NonNull String name);

    /**
     * Find metadata by ID with caching
     * Cache is per-request
     */
    @Query("SELECT i FROM #{#entityName} i WHERE i.id = :id")
    @Cacheable(value = METADATA_CACHE, key = "#id", unless = "#result == null")
    @NotNull
    Optional<MetadataEntity> findById(@NotNull @Param("id") UUID id);

}
