/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthorizationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.metadata.dm.authorization.RequireMetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.MetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.repository.MetadataRepository;
import com.finconsgroup.itserr.marketplace.metadata.dm.utils.AOPUtils;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class StatusAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatusAspect.class);
    private final MetadataRepository metadataRepository;

    @Around(value="@annotation(requireMetadataStatus)")
    public Object requireMetadataStatus(ProceedingJoinPoint pjp, RequireMetadataStatus requireMetadataStatus) throws Throwable {
        UUID metadataId = (UUID)AOPUtils.extractActualParam((ProceedingJoinPoint)pjp, (String)requireMetadataStatus.metadataIdParam(), UUID.class);
        MetadataEntity metadataEntity = (MetadataEntity)this.metadataRepository.findById(metadataId).orElseThrow(() -> new WP2ResourceNotFoundException(String.format("Metadata not found: %s", metadataId)));
        List<MetadataStatus> allowedStatuses = List.of(requireMetadataStatus.allowed());
        boolean isInAllowedStatus = allowedStatuses.stream().anyMatch(allowedStatus -> allowedStatus.equals((Object)metadataEntity.getStatus()));
        if (!isInAllowedStatus) {
            throw new WP2AuthorizationException(String.format("Metadata %s is not in allowed status: %s", metadataId, allowedStatuses));
        }
        return pjp.proceed();
    }

    @Generated
    public StatusAspect(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }
}

