package com.finconsgroup.itserr.marketplace.metadata.dm.authorization;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to check if the current authenticated user is the maintainer of the specified metadata.
 *
 * <p>The annotation requires specifying which method parameter contains the metadata ID.</p>
 *
 * <p>Example usage:</p>
 * <pre>
 * {@code
 * @RequireMetadataOwnership(metadataIdParam = "metadataId")
 * public OutputMetadataDto updateMetadata(UUID metadataId, InputUpdateMetadataDto dto) {
 *     // User must be the owner of the metadata
 *     // If not, WP2AuthorizationException is thrown before method execution
 * }
 * }
 * </pre>
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface RequireMetadataOwnership {

    /**
     * The name of the method parameter that contains the metadata ID.
     *
     * @return the parameter name (e.g., "metadataId")
     */
    String metadataIdParam() default "metadataId";
}