package com.finconsgroup.itserr.marketplace.metadata.dm.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description = "Moderation result enumeration")
public enum ModerationResult {
    APPROVED("approved"),
    REJECTED("rejected");

    private final String value;

    ModerationResult(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return value;
    }

    @JsonCreator
    public static ModerationResult fromString(String value) {
        if (value == null) {
            return null;
        }
        for (ModerationResult status : ModerationResult.values()) {
            if (status.value.equalsIgnoreCase(value)) {
                return status;
            }
        }
        throw new IllegalArgumentException("Unknown ModerationResult: " + value);
    }
}