/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.dm.entity;

import com.finconsgroup.itserr.marketplace.metadata.dm.dto.MetadataStatus;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.ArchivedMetadataEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.ArchivedMetadataFieldEntity;
import com.finconsgroup.itserr.marketplace.metadata.dm.entity.enumerated.MetadataCategoryEnum;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="archived_metadata")
public class ArchivedMetadataEntity
extends AbstractUUIDEntity {
    public static final int NAME_LENGTH = 50;
    public static final int DESCRIPTION_LENGTH = 2000;
    @Column(name="name", nullable=false, length=50)
    private String name;
    @Column(name="description", length=2000)
    private String description;
    @Enumerated(value=EnumType.STRING)
    @Column(name="category", nullable=false)
    private MetadataCategoryEnum category;
    @Column(name="creator_id")
    private UUID creatorId;
    @OneToMany(mappedBy="metadata", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ArchivedMetadataFieldEntity> fields;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private MetadataStatus status;
    @Column(name="moderation_message")
    private String moderationMessage;
    @Column(name="created_at")
    private Instant createdAt;
    @Column(name="updated_at")
    private Instant updatedAt;
    @Column(name="updated_by", columnDefinition="UUID")
    private UUID updatedBy;
    @Column(name="version")
    private long version;
    @Column(name="archived_at", nullable=false)
    private Instant archivedAt;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.createdAt == null) {
            this.createdAt = now;
        }
        if (this.updatedAt == null) {
            this.updatedAt = now;
        }
        if (this.archivedAt == null) {
            this.archivedAt = now;
        }
    }

    @Generated
    protected ArchivedMetadataEntity(ArchivedMetadataEntityBuilder<?, ?> b) {
        super(b);
        this.name = b.name;
        this.description = b.description;
        this.category = b.category;
        this.creatorId = b.creatorId;
        this.fields = b.fields;
        this.status = b.status;
        this.moderationMessage = b.moderationMessage;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.version = b.version;
        this.archivedAt = b.archivedAt;
    }

    @Generated
    public static ArchivedMetadataEntityBuilder<?, ?> builder() {
        return new ArchivedMetadataEntityBuilderImpl();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public MetadataCategoryEnum getCategory() {
        return this.category;
    }

    @Generated
    public UUID getCreatorId() {
        return this.creatorId;
    }

    @Generated
    public List<ArchivedMetadataFieldEntity> getFields() {
        return this.fields;
    }

    @Generated
    public MetadataStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getModerationMessage() {
        return this.moderationMessage;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public UUID getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public Instant getArchivedAt() {
        return this.archivedAt;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setCategory(MetadataCategoryEnum category) {
        this.category = category;
    }

    @Generated
    public void setCreatorId(UUID creatorId) {
        this.creatorId = creatorId;
    }

    @Generated
    public void setFields(List<ArchivedMetadataFieldEntity> fields) {
        this.fields = fields;
    }

    @Generated
    public void setStatus(MetadataStatus status) {
        this.status = status;
    }

    @Generated
    public void setModerationMessage(String moderationMessage) {
        this.moderationMessage = moderationMessage;
    }

    @Generated
    public void setCreatedAt(Instant createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setUpdatedBy(UUID updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public void setArchivedAt(Instant archivedAt) {
        this.archivedAt = archivedAt;
    }

    @Generated
    public String toString() {
        return "ArchivedMetadataEntity(name=" + this.getName() + ", description=" + this.getDescription() + ", category=" + String.valueOf(this.getCategory()) + ", creatorId=" + String.valueOf(this.getCreatorId()) + ", fields=" + String.valueOf(this.getFields()) + ", status=" + String.valueOf(this.getStatus()) + ", moderationMessage=" + this.getModerationMessage() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", updatedBy=" + String.valueOf(this.getUpdatedBy()) + ", version=" + this.getVersion() + ", archivedAt=" + String.valueOf(this.getArchivedAt()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedMetadataEntity)) {
            return false;
        }
        ArchivedMetadataEntity other = (ArchivedMetadataEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        MetadataCategoryEnum this$category = this.getCategory();
        MetadataCategoryEnum other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        UUID this$creatorId = this.getCreatorId();
        UUID other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        MetadataStatus this$status = this.getStatus();
        MetadataStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$moderationMessage = this.getModerationMessage();
        String other$moderationMessage = other.getModerationMessage();
        if (this$moderationMessage == null ? other$moderationMessage != null : !this$moderationMessage.equals(other$moderationMessage)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        UUID this$updatedBy = this.getUpdatedBy();
        UUID other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !((Object)this$updatedBy).equals(other$updatedBy)) {
            return false;
        }
        Instant this$archivedAt = this.getArchivedAt();
        Instant other$archivedAt = other.getArchivedAt();
        return !(this$archivedAt == null ? other$archivedAt != null : !((Object)this$archivedAt).equals(other$archivedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedMetadataEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        MetadataCategoryEnum $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        UUID $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        MetadataStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $moderationMessage = this.getModerationMessage();
        result = result * 59 + ($moderationMessage == null ? 43 : $moderationMessage.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        UUID $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : ((Object)$updatedBy).hashCode());
        Instant $archivedAt = this.getArchivedAt();
        result = result * 59 + ($archivedAt == null ? 43 : ((Object)$archivedAt).hashCode());
        return result;
    }

    @Generated
    public ArchivedMetadataEntity() {
    }
}

