package com.finconsgroup.itserr.marketplace.metrics.dm.controller;

import com.finconsgroup.itserr.marketplace.metrics.dm.api.ConfigApi;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricsInterestWeightsConfigurationDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.ConfigService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

/**
 * REST controller class for handling metrics configurations related API requests.
 *
 * <p>Implements the {@link ConfigApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class ConfigController implements ConfigApi {

    /** Service for handling business logic related to metrics configurations. */
    private final ConfigService configService;

    @Override
    public OutputMetricsInterestWeightsConfigurationDto getInterestWeights() {
        return configService.getMetricsInterestWeightsConfiguration();
    }

}
