package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricType;
import org.mapstruct.Mapper;
import org.mapstruct.Named;

@Mapper(config = MapperConfiguration.class)
public interface MetricTypeMapper {

    /**
     * Converts an {@link MetricDtoType} to a {@link MetricType}.
     *
     * @param type the OutputMetricEventType to convert
     * @return the corresponding MetricType
     */
    @Named("metricDtoTypeToMetricType")
    MetricType metricDtoTypeToMetricType(MetricDtoType type);

    /**
     * Converts a {@link MetricType} to its corresponding {@link MetricDtoType}.
     *
     * @param type the MetricType to be converted
     * @return the corresponding MetricDtoType
     */
    @Named("metricTypeToMetricDtoType")
    MetricDtoType metricTypeToMetricDtoType(MetricType type);

}
