/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.dm.bs.MVUpdater;
import com.finconsgroup.itserr.marketplace.metrics.dm.bs.QueuedMVUpdater;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesDailyMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourcesSummaryMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.repository.MetricEventDailyCountRepository;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricInterestService;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricService;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricService
implements MetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricService.class);
    private final MetricEventDailyCountRepository metricEventDailyCountRepository;
    private final MetricInterestService metricInterestService;
    private final MetricMapper metricMapper;
    private final QueuedMVUpdater queuedMVUpdater;
    private final MVUpdater mvUpdater;

    public void update() {
        this.update(false);
    }

    public void update(boolean sync) {
        if (sync) {
            this.mvUpdater.update();
        } else {
            this.queuedMVUpdater.update();
        }
    }

    @NonNull
    public OutputResourcesDailyMetricsDto findResourcesDailyMetrics(@NonNull Set<String> resourcesIds, @NonNull LocalDate fromDate, @NonNull LocalDate toDate) {
        List metrics = this.metricEventDailyCountRepository.findByResourceIdInAndEventDayBetween(resourcesIds, fromDate, toDate);
        OutputResourcesDailyMetricsDto dailyMetrics = this.metricMapper.toOutputResourcesDailyMetricsDto((Collection)metrics);
        dailyMetrics.values().stream().flatMap(m -> m.values().stream()).forEach(m -> m.setInterest(this.metricInterestService.getTotalInterest(m)));
        return dailyMetrics;
    }

    @NonNull
    public OutputResourcesSummaryMetricsDto findResourcesSummaryMetrics(@NonNull Set<String> resourcesIds, LocalDate toDate) {
        List metrics = toDate == null ? this.metricEventDailyCountRepository.summarizeByResourceIds(resourcesIds) : this.metricEventDailyCountRepository.summarizeByResourceIdsAndEndDate(resourcesIds, toDate);
        return this.metricMapper.toOutputResourcesSummaryMetricsDto((Collection)metrics);
    }

    @Generated
    public DefaultMetricService(MetricEventDailyCountRepository metricEventDailyCountRepository, MetricInterestService metricInterestService, MetricMapper metricMapper, QueuedMVUpdater queuedMVUpdater, MVUpdater mvUpdater) {
        this.metricEventDailyCountRepository = metricEventDailyCountRepository;
        this.metricInterestService = metricInterestService;
        this.metricMapper = metricMapper;
        this.queuedMVUpdater = queuedMVUpdater;
        this.mvUpdater = mvUpdater;
    }
}

