package com.finconsgroup.itserr.marketplace.metrics.dm.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricsInterestWeightsConfigurationDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricTypeMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.repository.MetricInterestWeightRepository;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.ConfigService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

/**
 * Default implementation of {@link ConfigService}.
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultConfigService implements ConfigService {

    /** Repository for accessing metric interest weights */
    private final MetricInterestWeightRepository metricInterestWeightRepository;

    /** Mapper for converting between metric DTOs and entities */
    private final MetricTypeMapper metricTypeMapper;

    @Override
    @NonNull
    public OutputMetricsInterestWeightsConfigurationDto getMetricsInterestWeightsConfiguration() {

        final OutputMetricsInterestWeightsConfigurationDto config =
                new OutputMetricsInterestWeightsConfigurationDto();

        metricInterestWeightRepository.findAll()
                .forEach(m -> config.put(
                        metricTypeMapper.metricTypeToMetricDtoType(m.getMetric()),
                        m.getWeight()));

        return config;

    }

}
