package com.finconsgroup.itserr.marketplace.metrics.dm.repository;

import com.finconsgroup.itserr.marketplace.metrics.dm.entity.BeneficiaryInterestEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

/**
 * {@link BeneficiaryInterestRepository} repository.
 */
@Repository
public interface BeneficiaryInterestRepository extends JpaRepository<BeneficiaryInterestEntity, String> {

    /**
     * Counts the number of beneficiaries with an interest value less than the specified threshold.
     *
     * @param interest the threshold value to filter beneficiaries by their interest value
     * @return the count of beneficiaries with interest values less than the specified threshold
     */
    long countByInterestLessThan(double interest);

}
