/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.dm.service.impl;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputResourceMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputUserInterestInfoDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.BeneficiaryInterestEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricInterestWeightEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.mapper.MetricTypeMapper;
import com.finconsgroup.itserr.marketplace.metrics.dm.repository.BeneficiaryInterestRepository;
import com.finconsgroup.itserr.marketplace.metrics.dm.repository.MetricInterestWeightRepository;
import com.finconsgroup.itserr.marketplace.metrics.dm.service.MetricInterestService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricInterestService
implements MetricInterestService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricInterestService.class);
    private static final long INTEREST_WEIGHTS_TIMEOUT_SECS = 300L;
    private final MetricInterestWeightRepository metricInterestWeightRepository;
    private final BeneficiaryInterestRepository beneficiaryInterestRepository;
    private final MetricTypeMapper metricTypeMapper;
    private final Map<MetricDtoType, Double> interestWeights = new HashMap();
    private long interestWeightTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMetricsIfRequired() {
        Map map = this.interestWeights;
        synchronized (map) {
            if (this.interestWeightTimeout < System.currentTimeMillis()) {
                Map<MetricDtoType, Double> actualInterestWeights = this.metricInterestWeightRepository.findAll().stream().collect(Collectors.toMap(e -> this.metricTypeMapper.metricTypeToMetricDtoType(e.getMetric()), MetricInterestWeightEntity::getWeight));
                this.interestWeights.clear();
                this.interestWeights.putAll(actualInterestWeights);
                this.interestWeightTimeout = System.currentTimeMillis() + 300000L;
            }
        }
    }

    public double getTotalInterest(OutputResourceMetricsDto resourceMetrics) {
        this.loadMetricsIfRequired();
        return resourceMetrics != null ? resourceMetrics.getMetrics().entrySet().stream().filter(e -> e.getValue() != null).mapToDouble(e -> (Double)e.getValue() * this.interestWeights.getOrDefault(e.getKey(), 0.0)).sum() : 0.0;
    }

    @NonNull
    public OutputUserInterestInfoDto getUserInterestInfo(@NonNull UUID userId) {
        double interest = this.beneficiaryInterestRepository.findById((Object)userId.toString()).map(BeneficiaryInterestEntity::getInterest).map(d -> (double)Math.round(d * 100.0) / 100.0).orElse(0.0);
        long worseBeneficiaries = interest > 0.0 ? this.beneficiaryInterestRepository.countByInterestLessThan(interest) : 0L;
        long totalBeneficiaries = this.beneficiaryInterestRepository.count();
        return OutputUserInterestInfoDto.builder().userId(userId).interest(interest).worseEventsBeneficiaries((int)worseBeneficiaries).totalEventsBeneficiaries((int)totalBeneficiaries).build();
    }

    @Generated
    public DefaultMetricInterestService(MetricInterestWeightRepository metricInterestWeightRepository, BeneficiaryInterestRepository beneficiaryInterestRepository, MetricTypeMapper metricTypeMapper) {
        this.metricInterestWeightRepository = metricInterestWeightRepository;
        this.beneficiaryInterestRepository = beneficiaryInterestRepository;
        this.metricTypeMapper = metricTypeMapper;
    }
}

