/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.feeder.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.finconsgroup.itserr.marketplace.core.web.exception.ErrorResponseDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.client.MetricsBsClient;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.feeder.dto.metricbs.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.feeder.messaging.AbstractMetricEventConsumer;
import com.finconsgroup.itserr.messaging.consumer.AbstractSimpleCloudEventConsumer;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import feign.FeignException;
import io.cloudevents.CloudEvent;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractMetricEventConsumer<T extends MessagingEventDto<?>>
extends AbstractSimpleCloudEventConsumer<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMetricEventConsumer.class);
    private final MetricsBsClient metricsBsClient;
    private final MetricDtoType metricType;
    private final String eventType;

    public AbstractMetricEventConsumer(@NonNull MetricsBsClient metricsBsClient, @NonNull MetricDtoType metricType, @NonNull String eventType, @NonNull TypeReference<T> typeReference) {
        super(typeReference);
        this.metricType = metricType;
        this.eventType = eventType;
        this.metricsBsClient = metricsBsClient;
    }

    protected abstract void fillMetricEvent(@NonNull InputCreateMetricEventDto.InputCreateMetricEventDtoBuilder var1, @NonNull T var2, @NonNull CloudEvent var3) throws ValidationException;

    protected void handleEvent(T resourcePayload, @NonNull CloudEvent event) {
        if (resourcePayload == null) {
            log.warn("Received {} event with no payload. Message will be dropped.", (Object)this.eventType);
        } else if (resourcePayload.getTimestamp() == null) {
            log.warn("Received {} event with no timestamp. Message will be dropped.", (Object)this.eventType);
        } else if (resourcePayload.getUser() == null) {
            log.warn("Received {} event with no user. Message will be dropped.", (Object)this.eventType);
        } else if (resourcePayload.getUser().getId() == null) {
            log.warn("Received {} event with no user id. Message will be dropped.", (Object)this.eventType);
        } else {
            try {
                UUID userId = resourcePayload.getUser().getId();
                Instant eventTime = resourcePayload.getTimestamp();
                InputCreateMetricEventDto.InputCreateMetricEventDtoBuilder metricEventBuilder = InputCreateMetricEventDto.builder().eventTime(eventTime.atZone(ZoneOffset.UTC)).eventAuthor(userId.toString());
                this.fillMetricEvent(metricEventBuilder, resourcePayload, event);
                InputCreateMetricEventDto metricEvent = metricEventBuilder.build();
                OutputMetricEventDto createdMetricEvent = this.metricsBsClient.createMetricEvent(this.metricType, metricEvent);
                log.debug("Created metric event: {}", (Object)createdMetricEvent.getId());
            }
            catch (ValidationException e) {
                if (e.warnLevel) {
                    log.warn("Invalid metric event {}: {}. Skipping creation.", (Object)this.eventType, (Object)e.getMessage());
                } else {
                    log.info("Invalid metric event {}: {}. Skipping creation.", (Object)this.eventType, (Object)e.getMessage());
                }
            }
            catch (FeignException.Conflict e) {
                log.info("Metric event already exists. Skipping creation.");
            }
            catch (FeignException.UnprocessableEntity e) {
                String errorMessage = AbstractMetricEventConsumer.extractFirstErrorMessage((FeignException.FeignClientException)e);
                log.info("Event cannot be created: {}. Skipping creation.", (Object)errorMessage);
            }
        }
    }

    private static String extractFirstErrorMessage(FeignException.FeignClientException e) {
        Optional responseBodyOpt = e.responseBody();
        if (responseBodyOpt.isPresent()) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                ErrorResponseDto errorResponse = (ErrorResponseDto)mapper.readValue(new String(((ByteBuffer)responseBodyOpt.get()).array()), ErrorResponseDto.class);
                if (errorResponse != null && errorResponse.messages() != null && !errorResponse.messages().isEmpty()) {
                    return (String)errorResponse.messages().getFirst();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return e.getMessage();
    }
}

