package com.finconsgroup.itserr.marketplace.news.bs.bean;

import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.enums.EventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.time.Instant;

/**
 * Application event when a user action is taken on News.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class NewsApplicationEvent extends ApplicationEvent {

    private final EventType eventType;
    private final Instant eventTimestamp;

    public NewsApplicationEvent(@NonNull OutputNewsDetailDto source,
                                @NonNull EventType eventType) {
        super(source);
        this.eventType = eventType;
        this.eventTimestamp = Instant.now();
    }

    /**
     * The news on which the event occurred.
     *
     * @return the {@link OutputNewsDetailDto}
     */
    public OutputNewsDetailDto getNews() {
        return (OutputNewsDetailDto) getSource();
    }

}
