package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_CONTENT_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_REQUIRED_FIELD;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_TITLE_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_TYPE_LENGTH;

/**
 * Input DTO for creating news.
 */
@Schema(name = "InputCreateNewsDto", description = "DTO for creating news")
@Data
@Builder
@AllArgsConstructor
public class InputCreateNewsDto {

    @Schema(description = "The title of the news", example = "Annual Tech Conference 2025")
    @NotBlank(message = VALIDATION_ERROR_REQUIRED_FIELD)
    @Size(max = VALIDATION_TITLE_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String title;

    @Schema(description = "The type of news", example = "Technology")
    @Size(max = VALIDATION_TYPE_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String newsType;

    @Schema(description = "The content of the news", example = "Join us for the biggest tech conference of the year...")
    @Size(max = VALIDATION_CONTENT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String content;

    @Schema(description = "List of tags associated with the news", example = "[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<InputInstitutionalPageDto> institutionalPages;

    @Valid
    private InputImageDto image;

    @Schema(description = "List of unregistered authors")
    @Valid
    private List<InputAuthorDto> unRegisteredAuthors;

    @Schema(description = "List of registered authors", example = "[\"123e4567-e89b-12d3-a456-426614174002\", \"123e4567-e89b-12d3-a456-426614174003\"]")
    private List<String> registeredAuthorIds;
}
