package com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.news.bs.util.ValidationConstants.VALIDATION_ERROR_REQUIRED_FIELD;

/**
 * Input DTO for creating an Institutional Page.
 */
@Schema(name = "InputInstitutionalPageDto", description = "DTO for creating an Institutional Page")
@Data
@Builder
@AllArgsConstructor
public class InputInstitutionalPageDto {

    @Schema(description = "ID of the Institutional Page", example = "123e4567-e89b-12d3-a456-426614174002")
    @NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD)
    private UUID id;

    @Schema(description = "Name of Institutional Page", example = "WP3 - T-Res")
    @Size(max = MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String name;
}

