package com.finconsgroup.itserr.marketplace.news.bs.client.dto.userprofile;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputLocationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Output DTO representing a userprofile.
 */
@Schema(name = "OutputUserProfile", description = "DTO representing a userprofile in responses")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUserProfileDto {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "User's working location details")
    private OutputLocationDto workingLocation;
}
