package com.finconsgroup.itserr.marketplace.news.bs.dto;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputLocationDto;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * It represents the response for a news author.
 */
@SuperBuilder(toBuilder = true)
@Schema(
        title = "Author response DTO for news",
        description = "Represents the response for News Author"
)
@Data
@NoArgsConstructor
@EqualsAndHashCode(of = "id")
public class OutputNewsAuthorDto implements ResourceDetail {

    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "ORCID identifier of the user", example = "0000-0002-1825-0097")
    private String orcid;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "Working location details")
    private OutputLocationDto location;

    @NonNull
    @Override
    public String getItemId() {
        return id != null ? id.toString() : "";
    }
}
