package com.finconsgroup.itserr.marketplace.news.bs.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;
import org.springframework.lang.NonNull;

import java.util.UUID;

/**
 * It represents the response for an Institutional Page in news.
 */
@SuperBuilder(toBuilder = true)
@Schema(
        title = "Institutional Page response DTO for news",
        description = "Represents the response for Institutional in news "
)
@Data
@NoArgsConstructor
@EqualsAndHashCode(of = "id")
public class OutputNewsInstitutionalPageDto implements ResourceDetail {

    @Schema(description = "ID of the institutional page", example = "11111111-aaaa-0000-0000-000000000000")
    private UUID id;

    @Schema(description = "The name of the institutional page", example = "Criterion")
    private String name;

    @NonNull
    @Override
    public String getItemId() {
        return id.toString();
    }
}
