package com.finconsgroup.itserr.marketplace.news.bs.messaging;

import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import org.springframework.lang.NonNull;

/**
 * Message Producer responsible for publishing news-related resource messages
 */
public interface EventProducer {

    /**
     * Publishes an event message for created resource.
     *
     * @param resource the resource that was created
     */
    void publishCreateEvent(@NonNull MessagingEventDto<?> resource);

    /**
     * Publishes an event message for updated resource.
     *
     * @param resource the resource that was updated
     */
    void publishUpdateEvent(@NonNull MessagingEventDto<?> resource);

    /**
     * Publishes an event message for deleted resource.
     *
     * @param resource the resource that was deleted
     */
    void publishDeleteEvent(@NonNull MessagingEventDto<?> resource);

}
