package com.finconsgroup.itserr.marketplace.news.bs.service;

import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.OutputImageDto;
import org.springframework.lang.NonNull;
import org.springframework.web.multipart.MultipartFile;

/**
 * Service to handle business logic for managing event images
 */
public interface ImageService {
    /**
     * Creates an image file, creating a new version of the document.
     *
     * @param file the new image file
     * @return the {@link OutputImageDto}
     */
    @NonNull
    OutputImageDto createPublicImage(@NonNull MultipartFile file);

    /**
     * Replaces an image file, creating a new version of the document.
     *
     * @param id   the id of the image to be updated
     * @param file the new image file
     * @return the {@link OutputImageDto}
     */
    @NonNull
    OutputImageDto updatePublicImage(@NonNull String id, @NonNull MultipartFile file);
}
