package com.finconsgroup.itserr.marketplace.news.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.bean.DetailRequest;
import com.finconsgroup.itserr.marketplace.news.bs.client.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.institutionalpage.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.institutionalpage.OutputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsInstitutionalPageProvider;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import java.util.Set;

/**
 * Implementation of {@link DefaultNewsInstitutionalPageProvider} for News
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultNewsInstitutionalPageProvider implements NewsInstitutionalPageProvider {

    private final InstitutionalPageDmClient institutionalPageDmClient;

    @NonNull
    @Override
    public OutputPageDto<OutputNewsInstitutionalPageDto> getDetails(@NonNull DetailRequest request) {

        if (request.getResourceIds() == null || request.getResourceIds().isEmpty()) {
            return OutputPageDto.emptyWithPageSize(request.getPageRequestDto().getPageSize());
        }

        InputSearchPublishedInstitutionalPageDto inputSearchPublishedInstitutionalPageDto = InputSearchPublishedInstitutionalPageDto
                .builder()
                .ids(request.getResourceIds().stream().toList())
                .build();

        return institutionalPageDmClient.searchPublishedInstitutionalPages(
                        inputSearchPublishedInstitutionalPageDto,
                        Set.of(),
                        request.getPageRequestDto().getPageNumber(),
                        request.getPageRequestDto().getPageSize(),
                        request.getPageRequestDto().getSort(),
                        request.getPageRequestDto().getDirection())
                .map(this::mapFromSearchInstitutionalPageDto);
    }

    /**
     * Maps the response from search institutional page domain service to news institutional page dto
     *
     * @param institutionalPageDto the institutional page dto to map from
     * @return the mapped {@link OutputNewsInstitutionalPageDto}
     */
    private OutputNewsInstitutionalPageDto mapFromSearchInstitutionalPageDto(OutputSearchPublishedInstitutionalPageDto institutionalPageDto) {
        return OutputNewsInstitutionalPageDto
                .builder()
                .id(institutionalPageDto.getId())
                .name(institutionalPageDto.getName())
                .build();
    }
}
