/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.component;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.news.bs.bean.NewsApplicationEvent;
import com.finconsgroup.itserr.marketplace.news.bs.component.MessagingNewsApplicationEventListener;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.enums.EventType;
import com.finconsgroup.itserr.marketplace.news.bs.mapper.NewsMapper;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.EventProducer;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.dto.NewsCreatedMessagingAdditionalDataDto;
import com.finconsgroup.itserr.marketplace.news.bs.messaging.dto.NewsMessagingAdditionalDataDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import com.finconsgroup.itserr.messaging.dto.MessagingEventUserDto;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class MessagingNewsApplicationEventListener
implements ApplicationListener<NewsApplicationEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessagingNewsApplicationEventListener.class);
    private final EventProducer eventProducer;
    private final ResourceProducer resourceProducer;
    private final NewsMapper newsMapper;

    public void onApplicationEvent(@NonNull NewsApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        MessagingEventDto messagingEventDto = this.newsMapper.toMessagingEventDto(event.getNews());
        MessagingEventUserDto user = MessagingEventUserDto.builder().id((UUID)JwtTokenHolder.getUserId().orElse(null)).name((String)JwtTokenHolder.getName().orElse(null)).username((String)JwtTokenHolder.getPreferredUsername().orElse(null)).build();
        messagingEventDto.setUser(user);
        this.updateEventForType(event, messagingEventDto);
        this.publishEventForType(event, messagingEventDto);
    }

    private void updateEventForType(NewsApplicationEvent applicationEvent, MessagingEventDto<NewsMessagingAdditionalDataDto> messagingEventDto) {
        OutputNewsDetailDto outputNewsDto = applicationEvent.getNews();
        NewsMessagingAdditionalDataDto additionalData = this.createAdditionalData(applicationEvent.getEventType());
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$news$bs$enums$EventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                messagingEventDto.setTimestamp(outputNewsDto.getCreationTime());
                this.updateAdditionalDataForCreated(additionalData, outputNewsDto);
                break;
            }
            case 2: 
            case 3: {
                messagingEventDto.setTimestamp(applicationEvent.getEventTimestamp());
            }
        }
        messagingEventDto.setAdditionalData((Object)additionalData);
    }

    private NewsMessagingAdditionalDataDto createAdditionalData(EventType eventType) {
        if (eventType == EventType.CREATED) {
            return new NewsCreatedMessagingAdditionalDataDto();
        }
        return new NewsMessagingAdditionalDataDto();
    }

    private void updateAdditionalDataForCreated(NewsMessagingAdditionalDataDto additionalData, OutputNewsDetailDto outputNewsDto) {
        if (additionalData instanceof NewsCreatedMessagingAdditionalDataDto) {
            NewsCreatedMessagingAdditionalDataDto createdAdditionalDataDto = (NewsCreatedMessagingAdditionalDataDto)additionalData;
            createdAdditionalDataDto.setContent(outputNewsDto.getContent());
            if (outputNewsDto.getImage() != null && outputNewsDto.getImage().getUrl() != null) {
                createdAdditionalDataDto.setImageUrl(outputNewsDto.getImage().getUrl().toString());
            }
        }
    }

    private void publishEventForType(NewsApplicationEvent applicationEvent, MessagingEventDto<?> messagingEventDto) {
        switch (1.$SwitchMap$com$finconsgroup$itserr$marketplace$news$bs$enums$EventType[applicationEvent.getEventType().ordinal()]) {
            case 1: {
                this.resourceProducer.publishCreatedResource(applicationEvent.getNews());
                this.eventProducer.publishCreateEvent(messagingEventDto);
                break;
            }
            case 2: {
                this.resourceProducer.publishUpdatedResource(applicationEvent.getNews());
                this.eventProducer.publishUpdateEvent(messagingEventDto);
                break;
            }
            case 3: {
                this.resourceProducer.publishDeletedResource(applicationEvent.getNews());
                this.eventProducer.publishDeleteEvent(messagingEventDto);
            }
        }
    }

    @Generated
    public MessagingNewsApplicationEventListener(EventProducer eventProducer, ResourceProducer resourceProducer, NewsMapper newsMapper) {
        this.eventProducer = eventProducer;
        this.resourceProducer = resourceProducer;
        this.newsMapper = newsMapper;
    }
}

