/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.news.bs.controller;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.news.bs.api.NewsApi;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputCreateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.client.dto.newsDm.InputUpdateNewsDto;
import com.finconsgroup.itserr.marketplace.news.bs.dto.OutputNewsDetailDto;
import com.finconsgroup.itserr.marketplace.news.bs.service.NewsService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NewsController
implements NewsApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewsController.class);
    private final NewsService newsService;

    public OutputPageDto<OutputNewsDetailDto> findAll(int pageNumber, int pageSize, String sort, Sort.Direction direction) {
        return this.newsService.findAll(pageNumber, pageSize, sort, direction);
    }

    public OutputNewsDetailDto findById(UUID newsId) {
        return this.newsService.findById(newsId);
    }

    public OutputNewsDetailDto createNews(InputCreateNewsDto inputCreateNewsDto) {
        JwtTokenHolder.getUserIdOrThrow();
        return this.newsService.create(inputCreateNewsDto);
    }

    public OutputNewsDetailDto updateNewsById(UUID newsId, InputUpdateNewsDto inputUpdateNewsDto) {
        JwtTokenHolder.getUserIdOrThrow();
        return this.newsService.updateById(newsId, inputUpdateNewsDto);
    }

    public void deleteNewsById(UUID newsId) {
        JwtTokenHolder.getUserIdOrThrow();
        this.newsService.deleteById(newsId);
    }

    @Generated
    public NewsController(NewsService newsService) {
        this.newsService = newsService;
    }
}

