package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedAuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedNewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.AuthorEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class)
public interface ArchivedAuthorMapper {

    /**
     * Maps a {@link AuthorEntity} into a {@link ArchivedNewsEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "archivedNews", ignore = true)
    ArchivedAuthorEntity toArchivedEntity(AuthorEntity src);
}
