package com.finconsgroup.itserr.marketplace.news.dm.mapper;

import com.finconsgroup.itserr.marketplace.news.dm.entity.ArchivedNewsEntity;
import com.finconsgroup.itserr.marketplace.news.dm.entity.NewsEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;

@Mapper(config = MapperConfiguration.class, uses = {ArchivedAuthorMapper.class})
public interface ArchivedNewsMapper {

    /**
     * Maps a {@link NewsEntity} into a {@link ArchivedNewsEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    ArchivedNewsEntity toArchivedEntity(NewsEntity src);

    @AfterMapping
    default void setUnregisteredAuthors(@MappingTarget ArchivedNewsEntity archivedNewsEntity) {
        if (archivedNewsEntity != null && archivedNewsEntity.getUnRegisteredAuthors() != null) {
            archivedNewsEntity.getUnRegisteredAuthors().forEach(authorEntity -> authorEntity.setArchivedNews(archivedNewsEntity));
        }
    }
}
