/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.notification.bs.websocket;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import io.micrometer.common.util.StringUtils;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

@Component
public class WsHandshakeInterceptor
implements HandshakeInterceptor {
    public boolean beforeHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        UUID userId = JwtTokenHolder.getUserId().orElse(null);
        String username = JwtTokenHolder.getPreferredUsername().orElse(null);
        String email = JwtTokenHolder.getEmail().orElse(null);
        String acceptLanguage = request.getHeaders().getFirst("Accept-Language");
        if (userId == null || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)email)) {
            return false;
        }
        attributes.put("userId", userId);
        attributes.put("username", username);
        attributes.put("email", email);
        if (StringUtils.isNotBlank((String)acceptLanguage)) {
            attributes.put("acceptLanguage", acceptLanguage);
        }
        return true;
    }

    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, Exception exception) {
    }
}

