package com.finconsgroup.itserr.marketplace.notification.bs.client;

import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;

import java.util.UUID;

/**
 * Notification DM microservice client for internal APIs.
 */
public interface NotificationInternalDmClient {

    /**
     * Retrieves a user notification by id.
     *
     * @param id the id of the notification to retrieve
     * @param acceptLanguage Accept-Language header value.
     * @return the found {@link OutputUserNotificationDto} and HTTP status 200 (OK)
     */
    @GetMapping(value = "/notification/internal/notifications/{id}", produces = MediaType.APPLICATION_JSON_VALUE)
    OutputLocalizedUserNotificationDto findById(
            @PathVariable("id") UUID id,
            @RequestHeader(name = "Accept-Language", required = false) String acceptLanguage);

}
