package com.finconsgroup.itserr.marketplace.notification.bs.client.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.time.ZonedDateTime;
import java.util.UUID;

/**
 * Output DTO representing a user notification including localized text.
 */
@Schema(name = "OutputLocalizedUserNotificationDto", description = "DTO representing a user notification with localized text")
@Data
@Builder
@AllArgsConstructor
public class OutputLocalizedUserNotificationDto {

    @Schema(description = "Unique identifier of the user notification", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "The type of notification", example = "catalog-item-event-created")
    private String type;

    @Schema(description = "The notification message", example = "A message")
    private String message;

    @Schema(description = "ID of the referenced entity", example = "12345")
    private String referencedId;

    @Schema(description = "Flag indicating whether the notification has been read")
    private Boolean read;

    @Schema(description = "Flag indicating whether the notification has been archived")
    private Boolean archived;

    @Schema(description = "The last read time of the user notification", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime lastReadTime;

    @Schema(description = "The creation time of the notification", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

    @Schema(description = "The last update time of the notification", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime updateTime;

}
