package com.finconsgroup.itserr.marketplace.notification.bs.client.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.UUID;

/**
 * Output DTO representing a notification template.
 *
 * This class is used to model the structure of notification templates for outgoing responses. It contains attributes related to the template's unique
 * identifier, type, language, and message content.
 */
@Data
@Builder
@AllArgsConstructor
public class OutputNotificationTemplateDto {

    /**
     * The notification template identifier.
     */
    @Schema(description = "Unique identifier of the notification template", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    /**
     * The type of notification (e.g., "catalog-item-event-created", "catalog-item-event-status").
     */
    @Schema(description = "The type of notification", example = "catalog-item-event-created")
    private String type;

    /**
     * The language code for the notification template (e.g., "en", "it", "fr"). Uses ISO 639-1 two-letter language codes.
     */
    @Schema(description = "The language code", example = "en")
    private String languageCode;

    /**
     * The actual message template text that will be used for generating notifications. May contain placeholders that will be replaced with actual values when
     * sending notifications.
     */
    @Schema(description = "The message text which may contain placeholders", example = "A message for {{user}}")
    private String text;

}
