package com.finconsgroup.itserr.marketplace.notification.bs.mapper;

import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputLocalizedUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.client.dto.OutputUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notification.bs.event.NotificationCreatedEvent;
import com.finconsgroup.itserr.marketplace.notification.bs.websocket.dto.NotificationCreatedWsDto;
import org.mapstruct.Mapper;

/**
 * Mapper interface for converting notifications.
 */
@Mapper(config = MapperConfiguration.class)
public interface NotificationMapper {

    /**
     * Converts a notification DTO to a notification created event.
     *
     * @param notification the notification DTO to convert
     * @return a {@link NotificationCreatedEvent} containing the notification data
     */
    NotificationCreatedEvent toEvent(
            OutputUserNotificationDto notification);

    /**
     * Converts an {@link OutputLocalizedUserNotificationDto} into a {@link NotificationCreatedWsDto}.
     *
     * @param notification the notification DTO to convert
     * @return a {@link NotificationCreatedWsDto} containing the converted notification data
     */
    NotificationCreatedWsDto toWsDto(
            OutputLocalizedUserNotificationDto notification);

}
